﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Maps.MapControl;


namespace Shapes
{
    public partial class MainPage : UserControl
    {
        // The user defined polygon to add to the map.
        MapPolygon newPolygon = null;
        // The map layer containing the polygon points defined by the user.
        MapLayer polygonPointLayer = new MapLayer();
        // Determines whether the map is accepting user polygon points
        // through single mouse clicks.
        bool inCreatePolygonMode = false;


        public MainPage()
        {
            InitializeComponent();

            //AddNewPolygon();
            //AddNewPolyline();

            // Adds location points to the polygon for every single mouse click
            MapWithPolygon.MouseClick += new EventHandler<MapMouseEventArgs>(MapWithPolygon_MouseClick);
        }

        private void MapWithPolygon_MouseClick(object sender, MapMouseEventArgs e)
        {
            //If the map is accepting polygon points, create a point.
            if (inCreatePolygonMode)
            {
                // Creates a location for a single polygon point and adds it to
                // the polygon's point location list.
                Location polygonPointLocation = MapWithPolygon.ViewportPointToLocation(
                    e.ViewportPoint);
                newPolygon.Locations.Add(polygonPointLocation);

                // A visual representation of a polygon point.
                Rectangle r = new Rectangle();
                r.Fill = new SolidColorBrush(Colors.Red);
                r.Stroke = new SolidColorBrush(Colors.Yellow);
                r.StrokeThickness = 1;
                r.Width = 8;
                r.Height = 8;

                // Adds a small square where the user clicked, to mark the polygon point.
                polygonPointLayer.AddChild(r, polygonPointLocation);
            }
        }

        private void btnCreatePolygon_Click(object sender, RoutedEventArgs e)
        {
            // Toggles ON the CreatePolygonMode flag.
            if (((Button)sender).Tag.ToString() == "false")
            {
                ((Button)sender).Tag = "true";
                inCreatePolygonMode = true;

                txtButton.Text = "Create";
                txtDescription.Visibility = Visibility.Visible;

                // Clears any objects added to the polygon layer.
                if (NewPolygonLayer.Children.Count > 0)
                    NewPolygonLayer.Children.Clear();

                // Adds the layer that contains the polygon points
                NewPolygonLayer.Children.Add(polygonPointLayer);

                newPolygon = new MapPolygon();
                // Defines the polygon fill details
                newPolygon.Locations = new LocationCollection();
                newPolygon.Fill = new SolidColorBrush(Colors.Blue);
                newPolygon.Stroke = new SolidColorBrush(Colors.Green);
                newPolygon.StrokeThickness = 3;
                newPolygon.Opacity = 0.8;
            }
            //Toggle OFF the CreatePolygonMode flag.
            else
            {
                ((Button)sender).Tag = "false";
                inCreatePolygonMode = false;

                txtButton.Text = "Add New Polygon";
                txtDescription.Visibility = Visibility.Collapsed;

                //If there are two or more points, add the polygon layer to the map
                if (newPolygon.Locations.Count >= 2)
                {
                    // Removes the polygon points layer.
                    polygonPointLayer.Children.Clear();

                    // Adds the filled polygon layer to the map.
                    NewPolygonLayer.Children.Add(newPolygon);
                }
            }
        }

        //******************************************************
        void AddNewPolygon()
        {
            MapPolygon polygon = new MapPolygon();
            polygon.Fill = new System.Windows.Media.SolidColorBrush(System.Windows.Media.Colors.Red);
            polygon.Stroke = new System.Windows.Media.SolidColorBrush(System.Windows.Media.Colors.Yellow);
            polygon.StrokeThickness = 5;
            polygon.Opacity = 0.7;
            polygon.Locations = new LocationCollection() { 
                    new Location(20, -20), 
                    new Location(20, 20), 
                    new Location(-20, 20), 
                    new Location(-20, -20) };

            MapWithPolygon.Children.Add(polygon);
        }

        void AddNewPolyline()
        {
            MapPolyline polyline = new MapPolyline();
            polyline.Stroke = new System.Windows.Media.SolidColorBrush(System.Windows.Media.Colors.Red);
            polyline.StrokeThickness = 5;
            polyline.Opacity = 0.7;
            polyline.Locations = new LocationCollection() { 
                    new Location(10, -10), 
                    new Location(10, 10), 
                    new Location(-10, -10), 
                    new Location(-10, 10) };

            MapWithPolygon.Children.Add(polyline);
        }


    }
}
